/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.dao.impl;

import edu.ecompus.core.entity.Page;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationCriteria {
    private static final Logger logger = LoggerFactory.getLogger(PaginationCriteria.class);
    private static Field orderEntriesField = PaginationCriteria.getField(Criteria.class, "orderEntries");

    public static List query(Criteria c, Page page) {
        List _old_orderEntries = (List)PaginationCriteria.getFieldValue(orderEntriesField, c);
        boolean restore = false;
        if (_old_orderEntries.size() > 0) {
            restore = true;
            PaginationCriteria.setFieldValue(orderEntriesField, c, new ArrayList());
        }
        c.setProjection(Projections.rowCount());
        int rowCount = ((Long)c.uniqueResult()).intValue();
        page.setTotalCount(rowCount);
        if (rowCount == 0) {
            return Collections.EMPTY_LIST;
        }
        if (restore) {
            PaginationCriteria.setFieldValue(orderEntriesField, c, _old_orderEntries);
        }
        return c.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize()).setFetchSize(page.getPageSize()).list();
    }

    private static Field getField(Class clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            logger.warn("Class.getDeclaredField(String) failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Object getFieldValue(Field field, Object obj) {
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            logger.warn("Field.get(Object) failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void setFieldValue(Field field, Object target, Object value) {
        field.setAccessible(true);
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            logger.warn("Field.set(Object, Object) failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

