/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.common.security;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import edu.ecompus.core.common.exception.ML2ServiceException;
import edu.ecompus.core.common.security.ML2CaptchaService;
import edu.ecompus.core.util.RandomGenerator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.InitializingBean;

public class ML2CaptchaServiceImpl
implements ML2CaptchaService,
InitializingBean {
    private DefaultKaptcha producer;
    private Map captchaMap = new HashMap();
    private List preDefinedTexts;
    private int textCount = 0;

    public void afterPropertiesSet() throws Exception {
        this.producer = new DefaultKaptcha();
        this.producer.setConfig(new Config(new Properties()));
    }

    @Override
    public byte[] generateCaptchaImage(String key) throws ML2ServiceException {
        String text = (String)this.captchaMap.get(key);
        if (text == null) {
            throw new ML2ServiceException("Captch key '" + key + "' not found!");
        }
        BufferedImage image = this.producer.createImage(text);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", out);
        }
        catch (IOException e) {
            throw new ML2ServiceException("Failed to write captcha stream!", e);
        }
        return out.toByteArray();
    }

    @Override
    public String generateCaptchaKey() throws ML2ServiceException {
        String key = RandomGenerator.getRandomString(6);
        String value = this.getCaptchaText();
        this.captchaMap.put(key, value);
        return key;
    }

    private String getCaptchaText() {
        if (this.preDefinedTexts != null && !this.preDefinedTexts.isEmpty()) {
            String text = (String)this.preDefinedTexts.get(this.textCount);
            this.textCount = (this.textCount + 1) % this.preDefinedTexts.size();
            return text;
        }
        return this.producer.createText();
    }

    @Override
    public List getPreDefinedTexts() {
        return this.preDefinedTexts;
    }

    @Override
    public void setPreDefinedTexts(List preDefinedTexts) {
        this.preDefinedTexts = preDefinedTexts;
    }

    @Override
    public boolean validateCaptcha(String captchaKey, String captchaValue) throws ML2ServiceException {
        String text = (String)this.captchaMap.get(captchaKey);
        if (text == null) {
            throw new ML2ServiceException("CAPTCHA ERROR");
        }
        if (text.equals(captchaValue)) {
            this.captchaMap.remove(captchaKey);
            return true;
        }
        return false;
    }
}

