/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.common.email;

import edu.ecompus.core.common.email.ML2EmailProperty;
import edu.ecompus.core.common.email.ML2EmailService;
import edu.ecompus.core.common.exception.ML2ServiceException;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ML2EmailServiceImpl
implements ML2EmailService {
    private ML2EmailProperty emailProperty;
    private JavaMailSender javaMailSender;

    @Override
    public void sendMail(String email, String subject, String content, String siteName) throws ML2ServiceException {
        try {
            MimeMessage msg = this.javaMailSender.createMimeMessage();
            MimeMessageHelper msgHelper = new MimeMessageHelper(msg);
            try {
                msgHelper.setFrom(this.emailProperty.getSystemEmail(), siteName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            msgHelper.setTo(email);
            msgHelper.setSubject(subject);
            msgHelper.setText(content, true);
            this.javaMailSender.send(msg);
        }
        catch (MessagingException e) {
            throw new ML2ServiceException("Faild to send mail.", e);
        }
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public ML2EmailProperty getEmailProperty() {
        return this.emailProperty;
    }

    public void setEmailProperty(ML2EmailProperty emailProperty) {
        this.emailProperty = emailProperty;
    }
}

