package edu.ecompus.core.web;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import edu.ecompus.core.common.exception.ML2ServiceException;
import edu.ecompus.core.common.security.ML2CaptchaService;

public class CaptchaImageServlet extends HttpServlet {
	private static final long serialVersionUID = -8099246099404079788L;
	
	private ApplicationContext context;
	
	public void init() throws ServletException
	{
		super.init();
		context = WebApplicationContextUtils.getWebApplicationContext(getServletContext());
	}
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		ML2CaptchaService service = (ML2CaptchaService)context.getBean("captchaService");
		try
		{
			String captchaKey = service.generateCaptchaKey();
			response.setContentType("image/jpeg");
			OutputStream out = response.getOutputStream();
			out.write(service.generateCaptchaImage(captchaKey));
			out.close();
		}
		catch (ML2ServiceException e)
		{
			response.sendError(400, e.getMessage());
		}
	}

}
