package edu.ecompus.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;



/**
 * 
 * 敏感词过滤器
 * <li>Pattern根据正则表达式编译生成pattern
 * <li>Matcher根据pattern生成matcher
 * <li>matcher再和字符串匹配
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class KeyWordFilterUtil {
	private static Logger logger = LoggerFactory.getLogger(KeyWordFilterUtil.class);
	//关键词文本属性
	private static Pattern pattern = null;
	//关键词管理器
	private static Properties props = null;
	//路径位置
	private static String webPath = null;
	/**
	 * 通过works.properties初始化敏感词
	 * @throws Exception
	 */
	public static void initPatternByProps(String webpath) throws Exception{
		webPath = webpath; 
		try
		{
			props = PropertiesLoaderUtils.loadAllProperties("works.properties");
			initPatternByKeyText(props.stringPropertyNames());
		}catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * 初始化正则敏感词
	 * @param filePath		敏感词路径
	 * @throws Exception
	 */
	public static void initPattern(String filePath) throws Exception{
		if(pattern!=null) pattern = null;
		
		StringBuilder sb = new StringBuilder("");	
		BufferedReader bf = new BufferedReader(new FileReader(filePath));
		//读取敏感词库	
		sb.append("(");
		String line;
		int flag = 0;
		while((line = bf.readLine()) != null){
			logger.info(flag + " - " + line);
			flag ++;
			sb.append(line + "|");
		}
		//去除字符串的最后的|
		sb.deleteCharAt(sb.length()-1);			
		sb.append(")");
		pattern = Pattern.compile(sb.toString());
		bf.close();
	}
	
	/**
	 * Key Text
	 * @param keylist
	 * @throws Exception
	 */
	public static void initPatternByKeyText(Collection<String> keylist) throws Exception{
		StringBuilder sb = new StringBuilder("(");	
		for(String key : props.stringPropertyNames()){
			sb.append(key + "|");
		}
		//去除字符串的最后的|
		sb.deleteCharAt(sb.length()-1);			
		sb.append(")");
		
		if(logger.isInfoEnabled()){
			logger.info("过滤词:"+sb.toString());
		}
		pattern = Pattern.compile(sb.toString());
	}
	
	/**
	 * 获取关键词
	 */
	public static Collection<String> getList(){
		//
		if(props!=null){
			return props.stringPropertyNames();
		}
		
		//
		return new ArrayList<String>();
	}
	
	/**
	 * 添加关键词
	 */
	public static void addKey(String key){
		if(logger.isInfoEnabled()){
			logger.info("添加关键词:" + key);
		}
		
		props.put(key, "");
	}
	
	/**
	 * 删除关键词
	 */
	public static void deleteByKey(String key){
		if(logger.isInfoEnabled()){
			logger.info("删除关键词:" + key);
		}
		props.remove(key);
	}
	
	public static void save() throws Exception{
		if(logger.isInfoEnabled()){
			logger.info("保存到works2.properties");
		}
		//文件输出流 
		String file = webPath + File.separator + "WEB-INF\\classes" + File.separator + "works.properties";
		FileOutputStream fos = new FileOutputStream(file); 
		
		//将Properties集合保存到流中 
		props.store(fos, "Save AT (c) 36uk.com " + DateUtil.date2Str(new Date())); 
		fos.close();//关闭流
		
		//重新同步正则
		initPatternByKeyText(props.stringPropertyNames());
	}
	
	// 执行过滤
	public static String doFilter(String str){
		Matcher matcher = pattern.matcher(str);
		str = matcher.replaceAll("*");
		return str;
	}

}
