package edu.ecompus.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
	public static byte[] gzip(byte data[])
	{
		ByteArrayOutputStream byteOutput = null;
		
		if(data!=null && data.length>0){
			byteOutput = new ByteArrayOutputStream(10240);
			GZIPOutputStream output = null;
			try
			{
				output = new GZIPOutputStream(byteOutput);
				output.write(data);
			}
			catch (IOException e)
			{
				if (output != null){
					try
					{
						output.close();
					}
					catch (IOException e2) { }
				}
					
			}finally	{
				if (output != null){
					try
					{
						output.close();
					}
					catch (IOException e) { }
				}
			}
		}
		
		return byteOutput.toByteArray();
		
	}
	
}
