package edu.ecompus.core.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 日期工具类
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class DateUtil {
	/**
	 * 日期时间格式
	 */
	private static String DATETIME_FORMAT = "yyyy-MM-dd HH:mm";
	/**
	 * 日期格式
	 */
	private static String DATE_FORMAT = "yyyy-MM-dd";
	/**
	 * 生肖
	 */
	public static final String zodiacArr[] = {
		"猴", "鸡", "狗", "猪", "鼠", "牛", "虎", "兔", "龙", "蛇", 
		"马", "羊"
	};
	/**
	 * 星座
	 */
	public static final String constellationArr[] = {
		"水瓶座", "双鱼座", "牡羊座", "金牛座", "双子座", "巨蟹座", "狮子座", "处女座", "天秤座", "天蝎座", 
		"射手座", "魔羯座"
	};
	public static final int constellationEdgeDay[] = {
		20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 
		22, 22
	};

	public static Date previous(int days)
	{
		return new Date(System.currentTimeMillis() - (long)days * 0x36ee80L * 24L);
	}

	public static String formatDateTime(Date d)
	{
		return (new SimpleDateFormat(DATETIME_FORMAT)).format(d);
	}

	public static String formatDateTime(long d)
	{
		return (new SimpleDateFormat(DATETIME_FORMAT)).format(Long.valueOf(d));
	}

	public static String formatDate(Date d)
	{
		return (new SimpleDateFormat(DATE_FORMAT)).format(d);
	}

	public static Date parseDate(String d)
	{
		try{
			return (new SimpleDateFormat(DATE_FORMAT)).parse(d);
		}catch(Exception e){
			
		}
		return null;
	}

	public static Date parseDateTime(String dt)
	{
		try{
			return (new SimpleDateFormat(DATETIME_FORMAT)).parse(dt);
		}catch(Exception e){
		}
		return null;
	}

	public static int getYearOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.get(1);
		} else
		{
			return -1;
		}
	}

	public static int getMonthOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.get(2) + 1;
		} else
		{
			return -1;
		}
	}

	public static int getDayOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.get(5);
		} else
		{
			return -1;
		}
	}

	public static int getHourOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.get(11);
		} else
		{
			return -1;
		}
	}

	public static int getMinuteOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.get(12);
		} else
		{
			return -1;
		}
	}

	public static int getSecondOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.get(13);
		} else
		{
			return -1;
		}
	}

	public static long getMillisOfDate(Date p_date)
	{
		if (null != p_date)
		{
			Calendar c = Calendar.getInstance();
			c.setTime(p_date);
			return c.getTimeInMillis();
		} else
		{
			return -1L;
		}
	}
	

	/**
	 * 通过生日生成年龄
	 * @param birthDay
	 * @return
	 * @throws Exception
	 */
	public static int getAge(Date birthDay)
		throws Exception
	{
		Calendar cal = Calendar.getInstance();
		if (cal.before(birthDay))
			throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
		int yearNow = cal.get(1);
		int monthNow = cal.get(2);
		int dayOfMonthNow = cal.get(5);
		cal.setTime(birthDay);
		int yearBirth = cal.get(1);
		int monthBirth = cal.get(2);
		int dayOfMonthBirth = cal.get(5);
		int age = yearNow - yearBirth;
		if (monthNow <= monthBirth)
			if (monthNow == monthBirth)
			{
				if (dayOfMonthNow < dayOfMonthBirth)
					age--;
			} else
			{
				age--;
			}
		return age;
	}

	public static String formatDayHour(long ms, int validDay)
	{
		int temp = (int)(ms / 0x36ee80L);
		int day = 0;
		int hour = 0;
		if (temp % 24 == 0)
		{
			day = (validDay * 24 - temp) / 24;
			hour = 0;
		} else
		{
			day = (validDay * 24 - temp) / 24;
			if (temp < 24)
				hour = 24 - temp;
			else
				hour = 24 - temp % 24;
		}
		return day + "天" + hour + "小时";
	}

	public static String date2Zodica(Calendar time)
	{
		return zodiacArr[time.get(1) % 12];
	}

	public static String date2Constellation(Calendar time)
	{
		int month = time.get(2);
		int day = time.get(5);
		if (day < constellationEdgeDay[month])
			month--;
		if (month >= 0)
			return constellationArr[month];
		else
			return constellationArr[11];
	}
	
	/**
	 * 将时间转换为字符串,1小时内转换为文本,1小时后转换为DATETIME_FORMAT
	 * @param date
	 * @return
	 */
	public static String date2Str(Date date){
		StringBuffer buffer = new StringBuffer();
		long millTime = System.currentTimeMillis() - date.getTime();
		long second = millTime/1000;
		long minutes = second/60;
		long hours = minutes/60;
		if(second < 60 )
		{
			buffer.append(second).append("秒前");
		}else if(minutes < 60)
		{
			buffer.append(minutes).append("分钟前");
		}else if(hours < 24 )
		{
			buffer.append(hours).append("小时前");
		}else
		{
			buffer.append(new SimpleDateFormat(DATETIME_FORMAT).format(date));
		}
		return buffer.toString();
	}
	
	/**
	 * 计算两个日期的时间差,返回几天几小时几分几秒
	 * @param sd
	 * @param ed
	 * @return
	 */
	public static float date2diff(Date sd, Date ed){
		Long s = sd.getTime();
		Long e = ed.getTime();
		if(s>e){
			Long tmp = s;
			s = e;
			e = tmp;
		}
		Long diff = e - s;
		long nd = 1000*24*60*60;//一天的毫秒数
		long nh = 1000*60*60;//一小时的毫秒数
		long nm = 1000*60;//一分钟的毫秒数
		long ns = 1000;//一秒钟的毫秒数
		
		long day = diff/nd;//计算差多少天
		long hour = diff%nd/nh;//计算差多少小时
		long min = diff%nd%nh/nm;//计算差多少分钟
		long sec = diff%nd%nh%nm/ns;//计算差多少秒//输出结果
		System.out.println("时间相差："+day+"天"+hour+"小时"+min+"分钟"+sec+"秒。");
		
		return Float.valueOf(String.format("%s.%s", day, hour));
	}
}
