package edu.ecompus.core.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
/**
 * 日志配置
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class ML2LogbackConfigListener implements ServletContextListener {
	private static final Logger logger = LoggerFactory.getLogger(ML2LogbackConfigListener.class);
	private static final String CONFIG_LOCATION = "logbackConfigLocation";
	

	@Override
	public void contextInitialized(ServletContextEvent event) {
		String logbackConfigLocation = event.getServletContext().getInitParameter(CONFIG_LOCATION);
		String fn = event.getServletContext().getRealPath(logbackConfigLocation);
		try
		{
			LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
			loggerContext.reset();
			JoranConfigurator joranConfigurator = new JoranConfigurator();
			joranConfigurator.setContext(loggerContext);
			joranConfigurator.doConfigure(fn);
			logger.debug("loaded slf4j configure file from {}", fn);
		}
		catch (JoranException e)
		{
			logger.error((new StringBuilder()).append("can loading slf4j configure file from ").append(fn).toString(), e);
		}

	}


	@Override
	public void contextDestroyed(ServletContextEvent arg0) {
		// TODO Auto-generated method stub
	}

}
