package edu.ecompus.core.jmx;

import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * MINILIVE2 取样器特性
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class ML2SamplerAspect {
	private static final Logger logger = LoggerFactory.getLogger(ML2SamplerAspect.class);
	
	@SuppressWarnings({ "unchecked", "unused" })
	private Object doSample(ProceedingJoinPoint pjp, ThreadLocal tl) throws Throwable{
		long start = System.currentTimeMillis();
		try{
			Object obj = pjp.proceed();
			long last = System.currentTimeMillis() - start;
			logger.info((new StringBuilder()).append("doSample execute ").append(last).append("ms.").toString());
		
			Long acc = (Long)tl.get();
			if (acc != null)
				tl.set(new Long(acc.longValue() + last));
			return obj;
		}catch(Exception exception){
			long last = System.currentTimeMillis() - start;
			logger.info((new StringBuilder()).append("doSample execute ").append(last).append("ms.").toString());
			Long acc = (Long)tl.get();
			if (acc != null)
				tl.set(new Long(acc.longValue() + last));
			throw exception;
		}
		
	}
	
}
