package edu.ecompus.core.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import edu.ecompus.core.util.HttpUtil;


public class PerformanceHandlerInterceptor implements HandlerInterceptor {
	private static final Logger logger = LoggerFactory.getLogger(PerformanceHandlerInterceptor.class);
	private static final String START_TIME = "perf_start";
	
	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
			throws Exception {
		Long startTime = (Long)request.getAttribute(START_TIME);
		if (startTime != null)
		{
			long last = System.currentTimeMillis() - startTime.longValue();
			logger.info((new StringBuilder()).append("Request for URI: ").append(HttpUtil.getURL(request)).toString());
			logger.info((new StringBuilder()).append("Performace: ").append(last).append("ms.").toString());
		}

	}

	@Override
	public void postHandle(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse, Object obj, ModelAndView modelandview) throws Exception {
	}

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		request.setAttribute(START_TIME, Long.valueOf(System.currentTimeMillis()));
		return true;
	}

}
