package edu.ecompus.core.interceptor;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import edu.ecompus.core.util.HttpUtil;


public class GlobalHandlerExceptionResolver implements HandlerExceptionResolver {
	
	protected static final Logger logger = LoggerFactory.getLogger(GlobalHandlerExceptionResolver.class);
	
	@SuppressWarnings("unchecked")
	@Override
	public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
		String url = HttpUtil.getURL(request);
		logger.info((new StringBuilder()).append("Exception from URL: ").append(url).toString());
		logger.info((new StringBuilder()).append("Exception: ").append(ex.getMessage()).toString());
		Map map = new HashMap();
		String message = ex.getMessage();
		map.put("url", url);
		map.put("message", message != null ? ((Object) (message)) : "(未知错误)");
		return new ModelAndView("/error.html", map);
	}

}
