package edu.ecompus.core.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CachedResponseWrapper extends HttpServletResponseWrapper {
	public static final int OUTPUT_NONE = 0;
	public static final int OUTPUT_WRITER = 1;
	public static final int OUTPUT_STREAM = 2;
	private int outputType;
	private int status;
	private ServletOutputStream output;
	private PrintWriter writer;
	private ByteArrayOutputStream buffer;
	
	public CachedResponseWrapper(HttpServletResponse resp)throws IOException		
	{
		super(resp);
		outputType = 0;
		status = 200;
		output = null;
		writer = null;
		buffer = null;
		buffer = new ByteArrayOutputStream();
	}
	
	public int getStatus()
	{
		return status;
	}
	
	public void setStatus(int status)
	{
		super.setStatus(status);
		this.status = status;
	}
	
	public void setStatus(int status, String string)
	{
		super.setStatus(status, string);
		this.status = status;
	}
	
	public void sendError(int status, String string)
		throws IOException
	{
		super.sendError(status, string);
		this.status = status;
	}
	
	public void sendError(int status)
		throws IOException
	{
		super.sendError(status);
		this.status = status;
	}
	
	public void sendRedirect(String location)
		throws IOException
	{
		super.sendRedirect(location);
		status = 302;
	}
	
	public PrintWriter getWriter()
		throws IOException
	{
		if (outputType == 2)
			throw new IllegalStateException();
		if (outputType == 1)
		{
			return writer;
		} else
		{
			outputType = 1;
			writer = new PrintWriter(new OutputStreamWriter(buffer, getCharacterEncoding()));
			return writer;
		}
	}
	
	public ServletOutputStream getOutputStream()
		throws IOException
	{
		if (outputType == 1)
			throw new IllegalStateException();
		if (outputType == 2)
		{
			return output;
		} else
		{
			outputType = 2;
			output = new WrappedOutputStream(buffer);
			return output;
		}
	}
	
	public void flushBuffer()
		throws IOException
	{
		if (outputType == 1)
			writer.flush();
		if (outputType == 2)
			output.flush();
	}
	
	public void reset()
	{
		outputType = 0;
		buffer.reset();
	}
	
	public byte[] getResponseData()
		throws IOException
	{
		flushBuffer();
		return buffer.toByteArray();
	}
	
	
	
	class WrappedOutputStream extends ServletOutputStream
	{

		private ByteArrayOutputStream buffer;

		public void write(int b)
			throws IOException
		{
			buffer.write(b);
		}

		public byte[] toByteArray()
		{
			return buffer.toByteArray();
		}

		public WrappedOutputStream(ByteArrayOutputStream buffer)
		{
			super();
			this.buffer = buffer;
		}
	}
	
	

}
