package edu.ecompus.core.entity;

import java.io.Serializable;

/**
 * 分页类
 * @author Janny
 *
 */
public class Page implements Serializable {
	private static final long serialVersionUID = -4298760336080849230L;
	
	public static final int DEFAULT_PAGE_SIZE = 10;
	private int pageIndex;
	private int pageSize;
	private int totalCount;
	private int pageCount;

	public Page(int pageIndex, int pageSize)
	{
		if (pageIndex < 1)
			pageIndex = 1;
		if (pageSize < 1)
			pageSize = 1;
		this.pageIndex = pageIndex;
		this.pageSize = pageSize;
	}

	public Page(int pageIndex)
	{
		this(pageIndex, 10);
	}

	/**
	 * 当前索引页
	 * @return
	 */
	public int getPageIndex()
	{
		return pageIndex;
	}

	/**
	 * 一页多少个 
	 * @return
	 */
	public int getPageSize()
	{
		return pageSize;
	}

	/**
	 * 一页多少个 
	 * @return
	 */
	public int getPageCount()
	{
		return pageCount;
	}

	/**
	 * 总页数
	 * @return
	 */
	public int getTotalCount()
	{
		return totalCount;
	}

	/**
	 * 读取第一页
	 * @return
	 */
	public int getFirstResult()
	{
		return (pageIndex - 1) * pageSize;
	}

	/**
	 * 是否还有上一页
	 * @return
	 */
	public boolean getHasPrevious()
	{
		return pageIndex > 1;
	}

	/**
	 * 是否还有下一页
	 * @return
	 */
	public boolean getHasNext()
	{
		return pageIndex < pageCount;
	}

	public void setTotalCount(int totalCount)
	{
		this.totalCount = totalCount;
		pageCount = totalCount / pageSize + (totalCount % pageSize != 0 ? 1 : 0);
		if (totalCount == 0)
		{
			if (pageIndex != 1)
				throw new IndexOutOfBoundsException("Page index out of range.");
		} else
		if (pageIndex > pageCount)
			throw new IndexOutOfBoundsException("Page index out of range.");
	}

	/**
	 * 是否为空
	 * @return
	 */
	public boolean isEmpty()
	{
		return totalCount == 0;
	}
}
