package edu.ecompus.core.dao.impl;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate3.HibernateTemplate;

/**
 * DAO基础类 定义JdbcTemplate与HibernateTemplate
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public abstract class ML2GenericHibernateDao {
	protected final Logger logger = LoggerFactory.getLogger(getClass());
	/**
	 * JDBC模板
	 */
	@Autowired
	protected JdbcTemplate jdbcTemplate = null;
	/**
	 * Hibernate模板
	 */
	@Autowired
	protected HibernateTemplate hibernateTemplate = null;
	
}
