package edu.ecompus.core.common.security;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.imageio.ImageIO;

import org.springframework.beans.factory.InitializingBean;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;

import edu.ecompus.core.common.exception.ML2ServiceException;
import edu.ecompus.core.util.RandomGenerator;
/**
 * 安全验证码 实现类
 * @author Janny
 *
 */
public class ML2CaptchaServiceImpl implements ML2CaptchaService,
		InitializingBean {
	
	private DefaultKaptcha producer;
	@SuppressWarnings("unchecked")
	private Map captchaMap;
	@SuppressWarnings("unchecked")
	private List preDefinedTexts;
	private int textCount;
	
	@SuppressWarnings("unchecked")
	public ML2CaptchaServiceImpl()
	{
		captchaMap = new HashMap();
		textCount = 0;
	}
	
	public void afterPropertiesSet() throws Exception
	{
		producer = new DefaultKaptcha();
		producer.setConfig(new Config(new Properties()));
	}
	
	public byte[] generateCaptchaImage(String key) throws ML2ServiceException {
		String text = (String)captchaMap.get(key);
		if (text == null)
			throw new ML2ServiceException((new StringBuilder()).append("Captch key '").append(key).append("' not found!").toString());
		BufferedImage image = producer.createImage(text);
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		try
		{
			ImageIO.write(image, "jpg", out);
		}
		catch (IOException e)
		{
			throw new ML2ServiceException("Failed to write captcha stream!", e);
		}
		return out.toByteArray();
	}

	@SuppressWarnings("unchecked")
	public String generateCaptchaKey() throws ML2ServiceException {
		String key = RandomGenerator.getRandomString(6);
		String value = getCaptchaText();
		captchaMap.put(key, value);
		return key;
	}

	private String getCaptchaText() {
		if (preDefinedTexts != null && !preDefinedTexts.isEmpty())
		{
			String text = (String)preDefinedTexts.get(textCount);
			textCount = (textCount + 1) % preDefinedTexts.size();
			return text;
		} else
		{
			return producer.createText();
		}
	}

	@SuppressWarnings("unchecked")
	public List getPreDefinedTexts() {
		return preDefinedTexts;
	}
	
	@SuppressWarnings("unchecked")
	public void setPreDefinedTexts(List preDefinedTexts)
	{
		this.preDefinedTexts = preDefinedTexts;
	}
	

	public boolean validateCaptcha(String captchaKey, String captchaValue)
			throws ML2ServiceException {
		String text = (String)captchaMap.get(captchaKey);
		if (text == null)
			throw new ML2ServiceException("CAPTCHA ERROR");
		if (text.equals(captchaValue))
		{
			captchaMap.remove(captchaKey);
			return true;
		} else
		{
			return false;
		}
	}


}
