package edu.ecompus.core.common.email;

import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

import edu.ecompus.core.common.exception.ML2ServiceException;


/**
 * MINILIVE2 邮件发送 实现类
 * @author Janny
 *
 */
public class ML2EmailServiceImpl implements ML2EmailService {
	private ML2EmailProperty emailProperty;
	private JavaMailSender javaMailSender;
	
	public void sendMail(String email, String subject, String content, String siteName)
			throws ML2ServiceException {
		try
		{
			MimeMessage msg = javaMailSender.createMimeMessage();
			MimeMessageHelper msgHelper = new MimeMessageHelper(msg);
			try
			{
				msgHelper.setFrom(emailProperty.getSystemEmail(), siteName);
			}
			catch (UnsupportedEncodingException e)
			{
				e.printStackTrace();
			}
			msgHelper.setTo(email);
			msgHelper.setSubject(subject);
			msgHelper.setText(content, true);
			javaMailSender.send(msg);
		}catch (MessagingException e)
		{
			throw new ML2ServiceException("Faild to send mail.", e);
		}
	}
	
	
	public JavaMailSender getJavaMailSender()
	{
		return javaMailSender;
	}

	public void setJavaMailSender(JavaMailSender javaMailSender)
	{
		this.javaMailSender = javaMailSender;
	}

	public ML2EmailProperty getEmailProperty()
	{
		return emailProperty;
	}

	public void setEmailProperty(ML2EmailProperty emailProperty)
	{
		this.emailProperty = emailProperty;
	}

}
