package edu.ecompus.core.common.email;

import edu.ecompus.core.common.exception.ML2ServiceException;


/**
 * MINILIVE2 邮件发送接口
 * @author Janny
 *
 */
public interface ML2EmailService {
	/**
	 * 发送邮件
	 * <b>String to, String subject, String htmlText, String siteName</b>
	 * @param email		邮箱地址
	 * @param subject	主题
	 * @param content	邮件内容
	 * @param siteName	站点名称
	 * @throws ML2ServiceException
	 */
	public abstract void sendMail(String email, String subject, String content, String siteName) throws ML2ServiceException;
}
