/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.web;

import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.service.CompanyService;
import edu.ecompus.cas.service.UserService;
import edu.ecompus.core.util.CookieUtil;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebCompus {
    private static final String USERID_KEY = "cas_$user_id";
    private static final String SCHOOLID_KEY = "cas_$school_id";
    public static final String USERSHOWHELP_KEY = "cas_$showhelp";
    public static String COOKIE_LOGIN_USERNAME = "cas_$CNAME";
    public static String COOKIE_LOGIN_PASSWORD = "cas_$CPSW";

    public static void loginOut(HttpServletRequest req) {
        if (req != null && req.getSession() != null) {
            req.getSession().removeAttribute(USERID_KEY);
        }
    }

    public static Long getCurrentUserId(HttpServletRequest req) {
        return (Long)req.getSession().getAttribute(USERID_KEY);
    }

    public static User getCurrentUser(UserService userService, HttpServletRequest req) {
        Long userId = (Long)req.getSession().getAttribute(USERID_KEY);
        if (userId != null && userId > 0L) {
            return userService.getUserByUserId(userId);
        }
        return null;
    }

    public static Company getCurrentCompany(CompanyService companyService, HttpServletRequest req) {
        Long schoolId = (Long)req.getSession().getAttribute(SCHOOLID_KEY);
        if (schoolId != null && schoolId > 0L) {
            return companyService.getCompany(schoolId);
        }
        return null;
    }

    public static Long getCurrentCompanyId(HttpServletRequest req) {
        return (Long)req.getSession().getAttribute(SCHOOLID_KEY);
    }

    public static void setCurrentUser(HttpServletRequest req, Long userId) {
        req.getSession().setAttribute(USERID_KEY, (Object)userId);
    }

    public static void setCurrentCompanyId(HttpServletRequest req, Long companyId) {
        req.getSession().setAttribute(SCHOOLID_KEY, (Object)companyId);
    }

    public static Object getSessionAttrib(HttpServletRequest req, String sessionKey) {
        return req.getSession().getAttribute(sessionKey);
    }

    public static void setSessionAttrib(HttpServletRequest req, String sessionKey, Object object) {
        req.getSession().setAttribute(sessionKey, object);
    }

    public static void deleteSessionAttrib(HttpServletRequest request, String sessionKey) {
        Object obj = WebCompus.getSessionAttrib(request, sessionKey);
        if (obj != null) {
            obj = null;
        }
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        Cookie passwordCookie;
        Cookie usernameCookie = CookieUtil.getCookie((HttpServletRequest)request, (String)COOKIE_LOGIN_USERNAME);
        if (usernameCookie != null) {
            CookieUtil.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)usernameCookie);
        }
        if ((passwordCookie = CookieUtil.getCookie((HttpServletRequest)request, (String)COOKIE_LOGIN_PASSWORD)) != null) {
            CookieUtil.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)passwordCookie);
        }
        request.getSession().removeAttribute(USERID_KEY);
    }

    public static String getCookie_UserName(HttpServletRequest request) {
        Cookie usernameCookie = CookieUtil.getCookie((HttpServletRequest)request, (String)COOKIE_LOGIN_USERNAME);
        if (usernameCookie != null) {
            try {
                return URLDecoder.decode(usernameCookie.getValue(), "utf-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String getCookie_Password(HttpServletRequest request) {
        Cookie passwordCookie = CookieUtil.getCookie((HttpServletRequest)request, (String)COOKIE_LOGIN_PASSWORD);
        if (passwordCookie != null) {
            return passwordCookie.getValue();
        }
        return "";
    }
}

