/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.util;

public class GB2AlphaUtil {
    private char[] chartable = new char[]{'\u554a', '\u82ad', '\u64e6', '\u642d', '\u86fe', '\u53d1', '\u5676', '\u54c8', '\u54c8', '\u51fb', '\u5580', '\u5783', '\u5988', '\u62ff', '\u54e6', '\u556a', '\u671f', '\u7136', '\u6492', '\u584c', '\u584c', '\u584c', '\u6316', '\u6614', '\u538b', '\u531d', '\u5ea7'};
    private char[] alphatable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private int[] table = new int[27];

    public GB2AlphaUtil() {
        for (int i = 0; i < 27; ++i) {
            this.table[i] = GB2AlphaUtil.gbValue(this.chartable[i]);
        }
    }

    public char Char2Alpha(char ch) {
        int i;
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch - 97 + 65);
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch;
        }
        int gb = GB2AlphaUtil.gbValue(ch);
        if (gb < this.table[0]) {
            return '0';
        }
        for (i = 0; i < 26 && !this.match(i, gb); ++i) {
        }
        if (i >= 26) {
            return '0';
        }
        return this.alphatable[i];
    }

    public String String2Alpha(String SourceStr) {
        String Result = "";
        int StrLength = SourceStr.length();
        try {
            for (int i = 0; i < StrLength; ++i) {
                Result = Result + this.Char2Alpha(SourceStr.charAt(i));
            }
        }
        catch (Exception e) {
            Result = "";
        }
        return Result;
    }

    private boolean match(int i, int gb) {
        int j;
        if (gb < this.table[i]) {
            return false;
        }
        for (j = i + 1; j < 26 && this.table[j] == this.table[i]; ++j) {
        }
        if (j == 26) {
            return gb <= this.table[j];
        }
        return gb < this.table[j];
    }

    public static int gbValue(char ch) {
        String str = new String();
        str = str + ch;
        try {
            byte[] bytes = str.getBytes("GBK");
            if (bytes.length < 2) {
                return 0;
            }
            return (bytes[0] << 8 & 0xFF00) + (bytes[1] & 0xFF);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void main(String[] args) {
        GB2AlphaUtil obj1 = new GB2AlphaUtil();
        System.out.println(obj1.String2Alpha("asdf\u6d4b\u8bd5\uff1a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\uff01"));
        System.out.println(obj1.String2Alpha("\u9648"));
        System.out.println(obj1.String2Alpha("\u5f20"));
        System.out.println(obj1.String2Alpha("\u738b"));
        System.out.println(obj1.String2Alpha("\u5218"));
        System.out.println(obj1.String2Alpha("\u738b1"));
        System.out.println(GB2AlphaUtil.gbValue('a'));
    }
}

