/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.service.impl;

import edu.ecompus.cas.dao.RoleDAO;
import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.Role;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.cas.service.RoleService;
import edu.ecompus.core.service.GenerateService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="roleService")
public class RoleServiceImpl
extends GenerateService
implements RoleService {
    @Autowired
    RoleDAO roleDAO;
    @Autowired
    UserRoleDAO userRoleDAO;

    @Override
    public Role getRoleById(Long id) {
        return (Role)this.roleDAO.query(id);
    }

    @Override
    public List<Role> getRoleList() {
        return this.roleDAO.queryRoleAll();
    }

    @Override
    public UserRole addUserRole(UserRole userRole) {
        this.userRoleDAO.create(userRole);
        return userRole;
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserRole-byid_' + #userRole.id")
    public void updateUserRole(UserRole userRole) {
        this.userRoleDAO.update(userRole);
        if (userRole.getUser_id() != null && userRole.getUser_id() > 0L) {
            this.clearUserRoleCache(userRole.getUser_id());
        }
    }

    @Override
    @Cacheable(value={"default"}, key="'UserRole-byid_' + #id")
    public UserRole getUserRoleById(Long id) {
        return (UserRole)this.userRoleDAO.query(id);
    }

    @Override
    @Cacheable(value={"default"}, key="'userrolelistbyuserid_' + #userId")
    public List<UserRole> getUserRoleListByUser(Long userId) {
        if (userId != null && userId > 0L) {
            return this.userRoleDAO.queryUserRoleList(userId);
        }
        return Collections.emptyList();
    }

    @Override
    @CacheEvict(value={"default"}, key="'userrolelistbyuserid_' + #userId")
    public void clearUserRoleCache(Long userId) {
    }

    @Override
    @CacheEvict(value={"default"}, key="'userrolelistbyuserid_' + #userId")
    public void clearUserRole(Long userId) {
        if (userId != null && userId > 0L) {
            this.userRoleDAO.clearUserRole(userId);
        }
    }

    @Override
    @Cacheable(value={"default"}, key="'userrolelistbyuserid_' + #userId + #roleNames ")
    public List<UserRole> getUserRoleList(String roleNames, Long userId) {
        if (userId > 0L) {
            return this.userRoleDAO.queryUserRoleList(roleNames, userId);
        }
        return Collections.emptyList();
    }

    @Override
    @Cacheable(value={"default"}, key="'userrolebyuserid_' + #userId + #roleNames ")
    public UserRole getUserRoleByRoleName(String roleNames, Long userId) {
        List<UserRole> list = this.getUserRoleList(roleNames, userId);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Cacheable(value={"default"}, key="'userrolelistbyuserid_' + #userId + '-roleid'+ #roleId ")
    public List<UserRole> getUserRoleList2(Long roleId, Long userId) {
        return this.userRoleDAO.queryUserRoleList(roleId, userId);
    }

    @Override
    public boolean hasUsrRole(Long roleId, Long userId) {
        List<UserRole> urolelist = this.getUserRoleListByUser(userId);
        if (urolelist != null && urolelist.size() > 0) {
            for (UserRole ur : urolelist) {
                if (!ur.getRole_id().equals(roleId)) continue;
                return true;
            }
        }
        return false;
    }
}

