/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.mail;

import edu.ecompus.cas.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class VelocityMailService
extends JavaMailSenderImpl
implements JavaMailSender {
    private Properties mailHeaders = new Properties();
    private String from;
    private String subject;
    private String templateName;
    @Autowired
    private VelocityEngine velocityEngine;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private JavaMailSender meMailSender;
    @Autowired
    private JavaMailSender muleMailSender;

    public String renderText(Map model) throws VelocityException {
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.getVelocityEngine(), (String)this.getTemplateName(), (String)"utf-8", (Map)model);
    }

    public Properties getMailHeaders() {
        return this.mailHeaders;
    }

    public boolean sendMime(String nameOfTo, String emailOfTo, Map<String, Object> model) {
        try {
            return this.sendMime(nameOfTo + "<" + emailOfTo + ">", model);
        }
        catch (MailException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendMime(String to, Map<String, Object> model) {
        try {
            return this.sendMime(this.mergeSimpleMessage(to, model));
        }
        catch (MailException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendMime(SimpleMailMessage simpleMessage) {
        try {
            this.mailSender.send(this.toMimeMessage(simpleMessage));
            return true;
        }
        catch (MailException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized boolean sendMail(Map<String, Object> model, List<String> mutiUser) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            String text = null;
            try {
                text = this.renderText(model);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
            helper.setSubject(this.getSubject());
            helper.setFrom(this.getFrom());
            helper.setText(text, true);
            if (mutiUser != null && mutiUser.size() > 0) {
                InternetAddress[] to_mail = new InternetAddress[mutiUser.size()];
                for (int i = 0; i < mutiUser.size(); ++i) {
                    to_mail[i] = new InternetAddress(mutiUser.get(i));
                }
                helper.setTo(to_mail);
            }
            this.mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setMailHeaders(Properties mailHeaders) {
        this.mailHeaders = mailHeaders;
    }

    public String getFrom() {
        return this.from;
    }

    public Address getFromAddress() throws AddressException {
        return new InternetAddress(this.from);
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public JavaMailSender getJavaMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public SimpleMailMessage mergeSimpleMessage(String to, Map<String, Object> model) {
        String text = null;
        try {
            text = this.renderText(model);
        }
        catch (VelocityException e) {
            e.printStackTrace();
        }
        SimpleMailMessage message = new SimpleMailMessage();
        message.setSubject(this.getSubject());
        message.setFrom(this.getFrom());
        message.setTo(to);
        message.setText(text);
        return message;
    }

    public MimeMessagePreparator toMimeMessage(final SimpleMailMessage simpleMailMessage) {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
                message.setTo(simpleMailMessage.getTo());
                message.setSubject(simpleMailMessage.getSubject());
                message.setText(simpleMailMessage.getText(), true);
                message.setFrom(simpleMailMessage.getFrom());
            }
        };
        return preparator;
    }

    public synchronized boolean sendMeMail(Map<String, Object> model, List<String> mutiUser) {
        try {
            MimeMessage message = this.meMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            String text = null;
            try {
                text = this.renderText(model);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
            helper.setSubject(this.getSubject());
            helper.setFrom(this.getFrom());
            helper.setText(text, true);
            if (mutiUser != null && mutiUser.size() > 0) {
                InternetAddress[] to_mail = new InternetAddress[mutiUser.size()];
                for (int i = 0; i < mutiUser.size(); ++i) {
                    to_mail[i] = new InternetAddress(mutiUser.get(i));
                }
                helper.setTo(to_mail);
            }
            this.meMailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized boolean sendMuleMail(String toEmail, Map<String, Object> model) {
        try {
            MimeMessage message = this.meMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            String text = null;
            try {
                text = this.renderText(model);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
            helper.setSubject(this.getSubject());
            helper.setFrom(this.getFrom());
            helper.setText(text, true);
            if (!StringUtil.isEmpty(toEmail)) {
                helper.setTo(toEmail);
            }
            this.muleMailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

