/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.dao.impl;

import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class UserRoleDaoImpl
extends ML2TemplateGenericDao<UserRole>
implements UserRoleDAO {
    private static final Logger log = LoggerFactory.getLogger(UserRoleDaoImpl.class);

    public UserRoleDaoImpl() {
        super(UserRole.class);
    }

    @Override
    public List<UserRole> queryUserRoleList(Long userId) {
        return this.hibernateTemplate.find("from UserRole ur where ur.user_id=? order by role_id asc", new Object[]{userId});
    }

    @Override
    public void clearUserRole(Long userId) {
        StringBuffer sql = new StringBuffer("DELETE FROM UserRole ur where user_id=? and id>0");
        this.executeUpdate(sql.toString(), new Object[]{userId});
    }

    @Override
    public List<String> queryUserRoleResumeList(Long userId) {
        StringBuffer sql = new StringBuffer("SELECT name FROM ecompus2.TAB_ROLE where id in (SELECT role_id FROM ecompus2.TAB_USER_ROLE where user_id=").append(userId).append(")");
        return (List)this.jdbcTemplate.query(sql.toString(), new ResultSetExtractor(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString("name"));
                }
                return list;
            }
        });
    }

    @Override
    public List<UserRole> queryUserRoleList(String roleNames, Long userId) {
        String[] rolename = roleNames.split(",");
        String names = "";
        if (rolename.length > 0) {
            StringBuffer list = new StringBuffer("'").append(rolename[0]).append("'");
            if (rolename.length > 1) {
                for (String n : rolename) {
                    list.append(",'").append(n).append("'");
                }
            }
            names = list.toString();
        } else {
            names = roleNames;
        }
        StringBuffer sql = new StringBuffer("from UserRole ur where ur.user_id=").append(userId);
        sql.append(" and ur.role.name in (").append(names).append(")");
        sql.append(" order by role_id asc");
        log.info(sql.toString());
        return this.hibernateTemplate.find(sql.toString());
    }

    @Override
    public List<UserRole> queryUserRoleList(Long roleId, Long userId) {
        return this.hibernateTemplate.find("from UserRole ur where ur.user_id=? and role_id=?", new Object[]{userId, roleId});
    }
}

