package edu.ecompus.cas.web.init;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.DispatcherServlet;

/**
 * 
 * 初始化统一身份认证Servlet
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-15 上午10:17:17
 */
public class CasDispatcherServlet extends HttpServlet {

	private static final long serialVersionUID = 3809029408723262182L;
	
	 /** Key under which we will store the exception in the ServletContext. */
    public static final String CAUGHT_THROWABLE_KEY = "exceptionCaughtByServlet";
    
    /** 日志 */
    private static final Logger log = LoggerFactory.getLogger(CasDispatcherServlet.class);
    
    /** The actual DispatcherServlet to which we will delegate to. */
    private DispatcherServlet delegate = new DispatcherServlet();
    
    /** Boolean to determine if the application deployed successfully. */
    private boolean initSuccess = true;
    
    public void init(final ServletConfig config) {
        try {
            this.delegate.init(config);

        } catch (final Throwable t) {
            // let the service method know initialization failed.
            this.initSuccess = false;

            /*
             * no matter what went wrong, our role is to capture this error and
             * prevent it from blocking initialization of the servlet. logging
             * overkill so that our deployer will find a record of this problem
             * even if unfamiliar with Commons Logging and properly configuring
             * it.
             */

            final String message = "SafeDispatcherServlet: \n"
                + "The Spring DispatcherServlet we wrap threw on init.\n"
                + "But for our having caught this error, the servlet would not have initialized.";

            // log it via Commons Logging
            log.error(message, t);

            // log it to System.err
            System.err.println(message);
            t.printStackTrace();

            // log it to the ServletContext
            ServletContext context = config.getServletContext();
            context.log(message, t);

            /*
             * record the error so that the application has access to later
             * display a proper error message based on the exception.
             */
            context.setAttribute(CAUGHT_THROWABLE_KEY, t);

        }
    }

    /**
     * @throws ApplicationContextException if the DispatcherServlet does not
     * initialize properly, but the servlet attempts to process a request.
     */
    public void service(final ServletRequest req, final ServletResponse resp)
        throws ServletException, IOException {
        /*
         * Since our container calls only this method and not any of the other
         * HttpServlet runtime methods, such as doDelete(), etc., delegating
         * this method is sufficient to delegate all of the methods in the
         * HttpServlet API.
         */
        if (this.initSuccess) {
            this.delegate.service(req, resp);
        } else {
            throw new ApplicationContextException(
                "Unable to initialize application context.");
        }
    }

}
