package edu.ecompus.cas.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import edu.ecompus.cas.dao.UserVerifyDAO;
import edu.ecompus.cas.entity.UserVerify;
import edu.ecompus.cas.service.UserVerifyService;
import edu.ecompus.core.service.GenerateService;

@Service("UserVerifyService")
public class UserVerifyServiceImpl extends GenerateService implements UserVerifyService{

	@Autowired
	UserVerifyDAO userVerifyDAO;
	
	@Override
	public void createUserVerify(UserVerify userVerify) {
		if (userVerify != null) {
			userVerifyDAO.create(userVerify);
		}
	}

	@Override
	public UserVerify getUserVerifyByUserId(Long userId) {
		if (userId != null) {
			return this.userVerifyDAO.queryUserVerifyByUserId(userId);
		}
		return null;
	}

	@Override
	public int updateUserVerifyByUserId(UserVerify userVerify) {
		if (userVerify != null) {
			return this.userVerifyDAO.updateUserVerifyByUserId(userVerify);
		}
		return 0;
	}

	@Override
	public void deleteUserVerifyByToken(String token) {
		userVerifyDAO.deleteUserVerifyByToken(token);
	}

}

