package edu.ecompus.cas.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.dao.DistrictDAO;
import edu.ecompus.cas.entity.District;
import edu.ecompus.cas.service.DistrictService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;

/**
 * 区域位置服务层
 * 
//		//更新区域信息表
//		List<District> provinceList = districtService.getAllProvince();
//		for(District pp : provinceList){
//			List<District> cityList = districtService.getCityList(pp.getId());
//			for(District cc : cityList){
//				cc.setLevel(2);
//				districtService.updateDistrict(cc);
//				
//				List<District> areaList = districtService.getAreaList(cc.getId());
//				for(District aa : areaList){
//					aa.setLevel(3);
//					districtService.updateDistrict(aa);
//				}
//			}
//		}
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("distictService")
public class DistrictServiceImpl extends GenerateService implements
		DistrictService {
	
	@Autowired
	DistrictDAO districtDAO;
	
	@Override
	public District addDistrict(District district) {
		districtDAO.create(district);
		return district;
	}

	@CacheEvict(value="default",key="'district-cache-by' + #district.id")
	@Override
	public void updateDistrict(District district) {
		districtDAO.update(district);
	}

	
	@Cacheable(value="default",key="'district-cache-by' + #id")
	@Override
	public District getDistrictById(Long id) {
		if(id!=null && id>0)
			return districtDAO.query(id);
		else 
			return null;
	}

	@Cacheable(value="default",key="'district-provincelist'")
	@Override
	public List<District> getAllProvince() {
		return districtDAO.queryAllProvince();
	}
	
	@CacheEvict(value="default",key="'district-provincelist'")
	@Override
	public void clearAllProvinceCache() {
		// TODO 清除所有省的缓存
	}


	@Cacheable(value="default",key="'district-citylist-p' + #provinceId ")
	@Override
	public List<District> getCityList(Long provinceId) {
		return districtDAO.queryCityList(provinceId);
	}



	@Override
	public List<District> getDistrictListByIds(String ids) {
		return districtDAO.queryDistrictListByIds(ids);
	}

	@Cacheable(value="default",key="'district-arealist-c' + #cityId ")
	@Override
	public List<District> getAreaList(Long cityId) {
		return districtDAO.queryAreaList(cityId);
	}

	@Cacheable(value="default",key="'DistrictList-byname' + #name + '-lvl' + #level ")
	@Override
	public List<District> getFuzzy(String name, int level) {
		if(name!=null && !"".equals(name)){
			return districtDAO.queryFuzzy(name, level);
		}
		
		return Collections.emptyList();
	}

	@Cacheable(value="default",key="'District-byname' + #name + '-lvl' + #level ")
	@Override
	public District getDistrictFuzzy(String name, int level) {
		List<District> list = getFuzzy(name,level);
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

	@Cacheable(value="default",key="'District-AllCitys' ")
	@Override
	public List<District> getAllCitys() {
		return districtDAO.queryAllCitys();
	}

	@CacheEvict(value="default",key="'District-AllCitys' ")
	@Override
	public void clearAllCitysCache() {
		// TODO Auto-generated method stub
	}

	public List<District> getAllDistrict(Long parentId, int level) {
		return districtDAO.queryAllDistrict(parentId, level);
	}

	@CacheEvict(value="default", allEntries = true)
	@Override
	public void clearDistrictCache() {
		// TODO 清除省市区整个缓存
	}

	@Override
	public int deleteDistrict(List<District> districtList) {
		if(districtList != null && districtList.size() > 0) {
			District district = null;
			int deleteCount = 0;
			for(int i = 0; i < districtList.size(); i++) {
				district = districtList.get(i);
				if(district != null) {
					districtDAO.delete(district);
					deleteCount++;
				}
			}
			return deleteCount;
		} else {
			return 0;
		}
	}
	
	@Override
	public List<District> getHotCitys(Page page) {
		return districtDAO.queryHotCitys(page);
	}
}
