/****************************************************************
文件名称:CompanyServiceImpl.java                                                
项目名称: E-Compus CAS                                              
模块名称:                                                          
功能说明:                                                          
系统版本: 1.0                                                   
开发人员: 王树辉                                                                                                                                                  
开发时间: 2013-11-18 下午1:07:47                                     
相关文档:                                                          
*****************************************************************/
package edu.ecompus.cas.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.dao.CompanyDAO;
import edu.ecompus.cas.dao.CompanyRegDAO;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyReg;
import edu.ecompus.cas.service.CompanyService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;

/**
 * <b>学校</b> 服务层接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author wsh
 * @since Date： 2013-8-6 下午3:15:59
 */
@Service("companyService")
public class CompanyServiceImpl extends GenerateService implements CompanyService {
	
	/**
	 * CAS||学校-DAO
	 */
	@Autowired
	CompanyDAO companyDAO;
	
	@Autowired
	CompanyRegDAO companyRegDAO;
	
	@Override
	public List<Company> getCompanyList() {
		return companyDAO.queryCompanyList();
	}

	@Override
	public void creatCompany(Company company) {
		if (company != null) {
			companyDAO.create(company);
		}
	}
	
	@Override
	public Company getCompanyById(Long id) {
		return companyDAO.query(id);
	}

	@Cacheable(value="default",key="'company-cache-by' + #companyId")
	@Override
	public Company getCompany(Long companyId) {
		if (companyId != null && companyId>0) {
			return companyDAO.query(companyId);
		}
		return null;
	}

	@CacheEvict(value="default",key="'company-cache-by' + #company.id")
	@Override
	public void updateCompany(Company company) {
		if (company != null) {
			companyDAO.update(company);
		}
	}
	
	@Cacheable(value="default",key="'CompanyList-cache-State0'")
	@Override
	public List<Company> getCompanyListByState0() {
		return companyDAO.queryCompanyListByKey(null, 0, null, null, null, null);
	}
	
	@CacheEvict(value="default",key="'CompanyList-cache-State0'")
	@Override
	public void clearCompanyListByState0Cache() {
		// TODO 清除所有机构名录缓存
	}
	
	@Override
	public List<Company> getCompanyListByKey(String companyName, int status, String province, String city, String area, Page page) {
		return companyDAO.queryCompanyListByKey(companyName, status, province, city, area, page);
	}
	
	@Override
	public List<Company> getCompanyList(String keyword, String district,
			int classify, int status, Page page) {
		return companyDAO.queryCompanyList(keyword, district, classify, status, page);
	}

	@Override
	public List<Company> getCompanyListBySystem(String keyword, int status,
			Page page) {
		return companyDAO.queryCompanyListBySystem(keyword, status, page);
	}

	@Override
	public CompanyReg addCompanyReg(CompanyReg companyReg) {
		companyRegDAO.create(companyReg);
		return companyReg;
	}

	@Override
	public void updateCompanyReg(CompanyReg companyReg) {
		companyRegDAO.update(companyReg);
	}

	@Override
	public void delCompanyReg(CompanyReg companyReg) {
		companyRegDAO.delete(companyReg);
	}

	@Override
	public List<CompanyReg> getCompanyRegList(String keyword, int type,
			String province, String city, Page page) {
		return companyRegDAO.queryCompanyRegList(keyword, type, province, city, page);
	}

	@Override
	public CompanyReg getCompanyRegById(Long id) {
		return companyRegDAO.query(id);
	}

	@Override
	public Company getExistsCompany(String companyName, String province,
			String city, String area) {
		List<Company> list = companyDAO.queryCompanyListByKey(companyName, -1, province, city, area, new Page(1,1));
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		return null;
	}


}

