package edu.ecompus.cas.service;

import java.io.Serializable;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.Action;
import edu.ecompus.cas.entity.App;
import edu.ecompus.cas.entity.Module;
import edu.ecompus.cas.entity.Role;
import edu.ecompus.cas.entity.RolePermit;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserPermit;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.core.common.exception.ML2DaoException;
import edu.ecompus.core.entity.Page;

/**
 * 
 * 用户权限角色服务层接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:42:41
 */
@Transactional
public interface UserPermitService {
	//=========================通用接口=====================================
	
	/**
	 * 根据ID与Class类型查询实体
	 * @param clazz	Action,App,Module,ModuleAction,Role,RolePermit,User,UserPermit,UserRole
	 * @param id	clazz.id
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@Transactional(readOnly = true)
	Object query2(Class clazz, Serializable id);
	
	/**
	 * 添加实体
	 * @param clazz	Action,App,Module,ModuleAction,Role,RolePermit,User,UserPermit,UserRole
	 * @param id	clazz.id
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@Transactional(readOnly = true)
	Object add2(Class clazz, Object obj);
	
	/**
	 * 删除实体
	 * @param clazz	Action,App,Module,ModuleAction,Role,RolePermit,User,UserPermit,UserRole
	 * @param id	clazz.id
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@Transactional(readOnly = true)
	Object delete2(Class clazz, Object obj);
	
	/**
	 * 修改实体
	 * @param clazz	Action,App,Module,ModuleAction,Role,RolePermit,User,UserPermit,UserRole
	 * @param id	clazz.id
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@Transactional(readOnly = true)
	Object modify2(Class clazz, Object obj);
	
	//=========================用户相关接口=====================================
	/**
	 * 根据用户名查询用户
	 * @param userName
	 * @return
	 * @throws ML2DaoException
	 */
	public User queryUserByUserName(String userName) throws ML2DaoException;
	
	/**
	 * 统计登录次数
	 * @param userId	用户编号
	 * @return
	 */
	Long countLogin(Long userId);
	//=========================动作相关接口=====================================
	/**
	 * 创建动作
	 * @param action
	 * @throws ML2DaoException
	 */
	public void createAction(Action action) throws ML2DaoException;
	
	/**
	 * 取消动作
	 * @param action
	 * @throws ML2DaoException
	 */
	public void cancelAction(Action action) throws ML2DaoException;
	
	/**
	 * 分页读取动作(状态:正常)列表
	 * @param page		分页实体@see edu.ecompus.core.entity.Page
	 * @return
	 * @throws ML2DaoException
	 */
	public List<Action> queryActionList(Page page) throws ML2DaoException;
	//=========================模块相关接口=====================================
	/**
	 * 创建模块
	 * @param module
	 * @throws ML2DaoException
	 */
	public void createModule(Module module) throws ML2DaoException;
	
	/**
	 * 注销模块
	 * @param module
	 * @throws ML2DaoException
	 */
	public void cancelModule(Module module) throws ML2DaoException;
	
	//=========================应用相关接口=====================================
	/**
	 * 注册应用
	 * @param app
	 * @throws ML2DaoException
	 */
	public void createApp(App app) throws ML2DaoException;
	
	/**
	 * 注销应用
	 * @param app
	 * @throws ML2DaoException
	 */
	public void cancelApp(App app) throws ML2DaoException;
	
	/**
	 * 通过clientId查找App应用
	 * @param clientId
	 * @return
	 * @throws ML2DaoException
	 */
	App getAppByclientId(String clientId) throws ML2DaoException;
	
	//=========================角色相关接口=====================================
	/**
	 * 创建角色
	 * @param role
	 * @throws ML2DaoException
	 */
	public void createRole(Role role) throws ML2DaoException;
	
	
	//=========================用户角色相关接口=====================================
	/**
	 * 创建用户角色
	 * @param userRole
	 * @throws ML2DaoException
	 */
	public void createUserRole(UserRole userRole) throws ML2DaoException;
	
	/**
	 * 删除用户角色
	 * @param userRole
	 * @throws ML2DaoException
	 */
	public void deleteUserRole(UserRole userRole) throws ML2DaoException;
	
	/**
	 * 清除用户角色
	 * @param user
	 * @throws ML2DaoException
	 */
	public void clearUserRole(User user) throws ML2DaoException;
	
	/**
	 * 查询用户角色列表
	 * @param user
	 * @return
	 * @throws ML2DaoException
	 */
	public List<UserRole> queryUserRoleList(User user) throws ML2DaoException;
	
	
	/**
	 * 根据用户编号查询用户
	 * @param ids
	 * @return
	 */
	List<User> getUserByIds(String ids);
	
	//=========================用户权限相关接口=====================================
	/**
	 * 添加用户权限
	 * @param userpermit
	 * @throws ML2DaoException
	 */
	public void createUserPermit(UserPermit userpermit) throws ML2DaoException;
	
	/**
	 * 清除用户权限
	 * @param user
	 * @throws ML2DaoException
	 */
	public void clearUserPermit(User user) throws ML2DaoException;
	
	/**
	 * 删除用户权限
	 * @param userPermit
	 * @throws ML2DaoException
	 */
	public void deleteUserPermit(UserPermit userPermit) throws ML2DaoException;
	
	/**
	 * 查询用户权限
	 * @param user
	 * @return
	 * @throws ML2DaoException
	 */
	public List<UserPermit> queryUserPermitList(User user) throws ML2DaoException;
	//=========================角色权限相关接口=====================================
	/**
	 * 创建角色权限
	 * @param rolePermit
	 * @throws ML2DaoException
	 */
	public void createRolePermit(RolePermit rolePermit) throws ML2DaoException;
	
	/**
	 * 清除角色权限
	 * @param role
	 * @throws ML2DaoException
	 */
	public void clearRolePermit(Role role) throws ML2DaoException;
	
	/**
	 * 删除角色权限
	 * @param rolePermit
	 * @throws ML2DaoException
	 */
	public void deleteRolePermit(RolePermit rolePermit) throws ML2DaoException;
	
	/**
	 * 查询角色权限列表
	 * @param role
	 * @return
	 * @throws ML2DaoException
	 */
	public List<RolePermit> queryRolePermitList(Role role) throws ML2DaoException;
	
	/**
	 * 根据角色Ids查询角色权限列表
	 * @param roleIds	角色Ids(根据逗号隔开)
	 * @return
	 * @throws ML2DaoException
	 */
	public List<RolePermit> queryRolePermitList(String roleIds) throws ML2DaoException;
	
	
}
