package edu.ecompus.cas.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.Role;
import edu.ecompus.cas.entity.UserRole;

/**
 * <b>角色</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-4 下午4:24:27
 */
@Transactional
public interface RoleService {
	/**
	 * 根据ID查询角色
	 * @param id
	 * @return
	 */
	Role getRoleById(Long id);
	
	/**
	 * 查询所有系统角色
	 * @return
	 */
	List<Role> getRoleList();
	
	/**
	 * 添加用户角色
	 * @param userRole
	 * @return
	 */
	UserRole addUserRole(UserRole userRole);
	
	/**
	 * 更新用户角色
	 * @param userRole
	 */
	void updateUserRole(UserRole userRole);
	
	/**
	 * 根据ID读取用户角色
	 * @param id
	 * @return
	 */
	UserRole getUserRoleById(Long id);
	
	/**
	 * 根据用户Id读取角色列表
	 * @param userId
	 * @return
	 */
	List<UserRole> getUserRoleListByUser(Long userId);
	
	/**
	 * 清除用户角色缓存
	 * @param user
	 */
	void clearUserRoleCache(Long userId);
	
	/**
	 * 清除用户角色
	 * @param user
	 */
	void clearUserRole(Long userId);
	
	
	/**
	 * 根据角色Id与用户Id 查询用户角色列表
	 * @param roleNames	 角色名(以逗号隔开)
	 * @param userId	用户编号(必须>0)
	 * @return
	 */
	List<UserRole> getUserRoleList2(Long roleId, Long userId);
	
	
	/**
	 * 验证用户userId是否roleId权限
	 * @param roleId
	 * @param userId
	 * @return
	 */
	boolean hasUsrRole(Long roleId, Long userId);
	
	/**
	 * 查询用户角色列表
	 * @param roleNames	 角色名(以逗号隔开)
	 * @param userId	用户编号(必须>0)
	 * @return
	 */
	List<UserRole> getUserRoleList(String roleNames,Long userId);
	
	/**
	 * 查询用户角色
	 * @param roleNames	 角色名(以逗号隔开)
	 * @param userId	用户编号(必须>0)
	 * @return
	 */
	UserRole getUserRoleByRoleName(String roleNames,Long userId);
}
