package edu.ecompus.cas.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.District;
import edu.ecompus.core.entity.Page;



/**
 * 区域位置服务
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:20:15
 */
@Transactional
public interface DistrictService {
	/**
	 * 添加省市区
	 * @param district
	 */
	District addDistrict(District district);
	/**
	 * 更新省市区
	 * @param district
	 */
	void updateDistrict(District district);
	
	/**
	 * 根据ID
	 * @param id	clazz.id
	 * @return
	 */
	District getDistrictById(Long id);
	
	//==================省份接口========================
	/**
     * 查询所有省
     * 
     * @param page
     * @return
     */
    List<District> getAllProvince();
    /**
     * 清除所有省的缓存
     */
    void clearAllProvinceCache();
	//================== 城市接口========================
    
    /**
     * 查询某个省下的所有市信息
     * 
     * @param province
     * @return
     */
    List<District> getCityList(Long provinceId);
    
    
    /**
     * 查询所有的城市
     * @return
     */
    List<District> getAllCitys();
    
    /**
     * 清除所有的城市的缓存
     * @return
     */
    void clearAllCitysCache();
	//==================区域接口========================
    
    /**
     * 查询某个市下的所有区县信息
     * 
     * @param city
     * @return
     */
    List<District> getAreaList(Long cityId);
    
    //==================通用接口========================
    /**
	 * 通过codes查询地方
	 * @param ids	区域编号(以逗号的形式隔开)
	 * @return
	 */
    List<District> getDistrictListByIds(String ids);
    
    /**
     * 模糊查询District
     * @param name
     * @param level
     * @return
     */
    List<District> getFuzzy(String name, int level);
    
    /**
     * 模糊查询District
     * @param name
     * @param level
     * @return
     */
    District getDistrictFuzzy(String name, int level);
    
    /**
     * 根据父级区域id和区域级别查询所有符合条件的District
     * @param parentId 父级区域id
     * @param level 区域级别
     * @return List<District>
     */
    public List<District> getAllDistrict(Long parentId, int level);
    
    /**
     * 清除省市区整个缓存
     * @allEntries 是否清空所有缓存内容，缺省为 false，如果指定为 true，则方法调用后将立即清空所有缓存
     */
    void clearDistrictCache();
    
    /**
     * 删除District
     * @param district
     */
    public int deleteDistrict(List<District> districtList);
    
    /**
     * 获取热门城市
     * @param page
     * @return
     */
    public List<District> getHotCitys(Page page);
}
