package edu.ecompus.cas.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.App;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyApp;
import edu.ecompus.cas.entity.Feedback;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserApp;
import edu.ecompus.core.entity.Page;

/**
 * 应用服务层接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午5:28:30
 */
@Transactional
public interface AppService {

	/**
	 * 根据ID查询企业应用
	 * @param id
	 * @return
	 */
	CompanyApp getCompanyApp(Long id);
	
	/**
	 * 根据ID查询企业应用（带缓存）
	 * @param id
	 * @return
	 */
	CompanyApp getCompanyAppById(Long id);
	
	
	/**
	 * 分页读取应用(状态:正常)列表
	 * @param page
	 * @return
	 */
	List<App> getAppList(Page page);
	
	/**
	 * 查询学校所有APP
	 * @param school		*学校
	 * @param apptype		应用类型(-1不为条件,1-微博应用[适用于全校用户],2-OA应用[适用于教师用户)
	 * @param state			应用状态(-1不为条件,1-启动,2-禁用)
	 * @return
	 */
	List<CompanyApp> getCompanyApp(Company school,  int apptype,int state);
	
	/**
	 * 查询用户所有APP应用
	 * @param user		*当前用户
	 * @param school	*应用所属学校
	 * @param state		状态(-1不为条件,1-显示,2-隐藏)
	 * @return
	 */
	List<UserApp> getUserApp(User user,Company school,int state);
	
	/**
	 * 查询用户在微博所有正常的App应用列表
	 * @param user
	 * @return
	 */
	List<CompanyApp> getWeiboAppList(User user);
	
	/**
	 * 查询校园微信应用（带缓存）
	 * @param school	学校编号
	 * @return
	 */
	List<CompanyApp> getWeiAppList(Long school);
	/**
	 * 清除校园微信应用缓存
	 * @param schoolId
	 */
	void clearWeiAppListCache(Long schoolId);
	
	/**
	 * 查询校园微信应用（无缓存）
	 * @param school	学校编号
	 * @return
	 */
	List<CompanyApp> getWeiAppListNoCache(Long school);
	
	/**
	 * 激活/授权 应用(UserApp)
	 * @param user
	 * @param cpp
	 */
	void activateApp(User user, CompanyApp cpp);
	
	/**
	 * 判断用户是否激活应用
	 * @param user		用户实体
	 * @param cpp		单位应用
	 * @return
	 */
	boolean isActivateApp(User user, CompanyApp cpp);
	
	/**
	 * 根据ID查询APP
	 * @param id
	 * @return
	 */
	App getAppById(Long id);
	
	/**
	 * 根据clientId查询应用
	 * @param clientId
	 * @return
	 */
	App getByClientId(String clientId);
	
	/**
	 * 添加意见反馈
	 * @param feedback
	 * @return
	 */
	Feedback addFeedback(Feedback feedback);
	
	/**
	 * 根据Id查询意见反馈
	 * @param id
	 * @return
	 */
	Feedback getFeedbackById(Long id);
	
	
	/**
	 * 查询模块反馈意见
	 * @param app	（NULL不为条件,APP模块）
	 * @param status	（-1不为条件， 0：新意见，1:已处理；2:处理完成；3：删除（取消））
	 * @param page		（分页，NULL查询所有）
	 * @return
	 */
	List<Feedback> getFeedbackList(Long appid,int status,Page page);
	
	/**
	 * 查询所有应用反馈意见
	 * @param status	（-1不为条件， 0：新意见，1:已处理；2:处理完成；3：删除（取消））
	 * @param page		（分页，NULL查询所有）
	 * @return
	 */
	List<Feedback> getFeedbackList(int status,Page page);
	
	/**
	 * 统计【应用】意见反馈
	 * @param app		应用（NULL为其他）
	 * @param status	状态（-1不为条件， 0：新意见，1:已处理；2:处理完成；3：删除（取消））
	 * @return
	 */
	Long countAppFeedback(Long appid, int status);
}
