package edu.ecompus.cas.module.so;


import java.util.ArrayList;
import java.util.List;

import edu.ecompus.cas.entity.District;

import lombok.Data;

/**
 * 机构名录Server Object
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-29 下午6:23:34
 */
public @Data class CompanySO {
	private Long id;
	/**
	 * 机构名称
	 */
	private String name;
	/**
	 * 学校别名
	 */
	private String alias;	
	/** 省  **/
	private String province; //省
	private District distp = null;	//省实体
	
	/** 市  **/
	private String city; //市
	private District distc = null;	//市实体
	private List<District> cityList;//市列表
	
	/** 区、县  **/
	private String area; //区、县
	private District dista = null;	//区实体
	private List<District> areaList;//区列表
	/**
	 * 机构类型名称
	 */
	private String classifyname = "幼儿园";
	/**
	 * 机构类型	(1000-幼儿园 1001-小学 1002-初中 1003-高中 1004-职教 1005-大学)
	 */
	private int classify = 1000;
	
	private boolean iserror = false;
	
	private boolean isimported = false;
	/**
	 * 错误信息
	 */
	private List<String> errs = new ArrayList<String>();
}
