package edu.ecompus.cas.entity;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
/**
 * 
 * 角色权限表
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午3:40:40
 */
@Entity
@Table(name = "TAB_ROLE_PERMIT")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class RolePermit implements Serializable {
	private static final long serialVersionUID = -8800563605092304004L;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/** 角色 **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="role_id")
	private Role role;
	
	
	/**
     * 动作实体
     */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="action_id")
	private Action action;
	
	/**
	 * 模块实体
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="module_id")
	private Module module;
	
	
	
}
