package edu.ecompus.cas.entity;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
/**
 * oauth2.0  刷新令牌表
 * <desc>刷新标识，用来延长sessionkey的失效时间
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-11 下午4:36:04
 */
@Entity
@Table(name = "TAB_OAUTH2_REFRESH_TOKEN")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Oauth2RefreshToken implements Serializable {
	private static final long serialVersionUID = -4854441845648888880L;
	
	@Id
	private String tokenId;  
    private byte[] token;  
    private byte[] authentication;
    
    
    

}
