package edu.ecompus.cas.entity;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 
 * 模块表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-25 下午4:41:05
 */
@Entity
@Table(name = "TAB_MODULE")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Module implements Serializable {
	private static final long serialVersionUID = -2693349255401034207L;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
     * 模块名称       db_column: name  例如:日志,视频,相册,文章,校务OA 
     */ 	
	private String name;
	
	/**
	 * 模块资源	 db_column: url		例如:**\/teacher/** 
	 */
	private String url;
	
	/**
	 * 描述	 db_column: resume 
	 */
	private String resume;
	
	/**
	 * 状态  例如:1-正常    2-注销
	 */
	private int state;
	
	/**
	 * 父模块
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="parent_id")
	private Module parentModule;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;
	
	/**
	 * 级别,1-一级栏目,2-二级栏目,3-三级栏目,....
	 */
	private int level = 1;
	
	
	/**
	 * 子模块列表
	 */
	@Transient
	private Set<Module> subModules; 
	
	
	

}
