package edu.ecompus.cas.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 意见反馈表
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-1-21 下午1:37:49
 */
@Entity
@Table(name = "TAB_FEEDBACK")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public class Feedback implements Serializable {
	private static final long serialVersionUID = -2547901339131429996L;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 1l; //主键
	
	/**
	 * 应用
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="app_id")
	private App app;
	/**
	 * 内容
	 */
	private String content;
	
	/**
	 * 提交用户
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;	//cas 用户实体
	
	/**提交日期**/
	private Date   	createDate;	
	
	/**状态  0：新意见，1:已处理；2:处理完成；3：删除（取消）**/
	private int    	status;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}


	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public App getApp() {
		return app;
	}

	public void setApp(App app) {
		this.app = app;
	}			
	
	
	
}
