package edu.ecompus.cas.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;


import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 
 * 单位表
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 上午9:51:07
 */
@Entity
@Table(name="TAB_COMPANY")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Company implements BaseEntity {
	
	/**  * 	 */
	private static final long serialVersionUID = -8960554806778764577L;

	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/** 单位/学校  名称  **/
	private String name; //单位名称
	
	/**
	 * 学校别名
	 */
	private String alias;	
	
	/** 单位联系人  **/
	private String contact; //单位联系人
	/** 联系电话  **/
	private String telphone; //联系电话
	
	private String mobile; //联系手机
	
	/** 网址  **/
	private String website; //网址
	/** 联系地址  **/
	private String address; //联系地址
	/** 邮编  **/
	private String postcode; //邮编
	/** 邮箱  **/
	private String email; //邮箱
	/** 创建日期  **/
	private Date createDate; //创建日期
	
	/** 省  **/
	private String province; //省
	/** 市  **/
	private String city; //市
	/** 区、县  **/
	private String area; //区、县
	
	/** 状态 0-新申请 1-正常 2-注销  **/
	private int status; //状态 1-正常 2-注销3-未审核
	
	/** 单位简介  **/
	private String Introduction;  //单位简介
	
	/**
	 * 机构类型	(1000-幼儿园 1001-小学 1002-初中 1003-高中 1004-职教 1005-大学)
	 */
	private int classify = 1000;
	
	/** 
	 * 机构种类 	2000-公办园所,2001-民办园所,2002-合作园所,2003-早教机构
	 *   **/
	private int type = 2000;          //单位类型
	
	/**
	 * 园所等级 
	 * 0-示范园
	 * 1-一级园
	 * 2-二级园
	 * 3-三级园
	 */
	private int leavel = 0;
	
	/**
	 * 办园许可证
	 */
	private String licenseUrl;
	
	/**
	 * 管理员账号(等同于User.username)
	 */
	private String mangerUsername;
	
	/**微信公众平台TOKEN**/
	private String WXToken;		//微信公众平台TOKEN
	/**新用户加入公众平台欢迎词**/
	private String WXSubscribe;
	/**微信同步菜单时使用**/
	private String wxAppId;
	/**微信同步菜单时使用**/
	private String wxAppSecret;
	
	/**
	 * 消息加解密密钥
	 * <li>消息加密密钥由43位字符组成，可随机修改，字符范围为A-Z，a-z，0-9。
	 */
	private String encodingAESKey;
	
	/**
	 * 消息加解密方式
	 * <li>0-明文模式:明文模式下，不使用消息体加解密功能，安全系数较低
	 * <li>1-兼容模式:兼容模式下，明文、密文将共存，方便开发者调试和维护
	 * <li>2-安全模式（推荐）:安全模式下，消息包为纯密文，需要开发者加密和解密，安全系数高
	 */
	private int encodingType = 0;
	
	//微信公众服务号 `weixin` char(20) NOT NULL COMMENT '微信号',
	private String weixin;
	
	//公众帐号类型：1-订阅号  2-认证订阅号 3-服务号 4-高级服务号
	private int weixintype;
	
	//`tpltypeid` varchar(2) NOT NULL default '1' COMMENT '默认首页模版ID',
	private String tpltypeid = "1";
	//`tpltypename` varchar(20) NOT NULL COMMENT '首页模版名',
	private String tpltypename ;
	//`tpllistid` varchar(2) NOT NULL COMMENT '列表模版ID',
	//`tpllistname` varchar(20) NOT NULL COMMENT '列表模版名',
	//`tplcontentid` varchar(2) NOT NULL COMMENT '内容模版ID',
	//`tplcontentname` varchar(20) NOT NULL COMMENT '内容模版名',
	//`color_id` mediumint(4) NOT NULL default '0',
	
	//`headerpic` char(255) NOT NULL COMMENT '图文消息封面',
	private String headerpic;
	
	/**
	 * UK客服
	 */
	private String UKService;
	
	/**
	 * 备注
	 */
	private String remark;
	
	/**
	 * 是否屏蔽搜索
	 * 1-是
	 * 其他-否
	 */
	private int hidden = 0;
	
	/**
	 * 活跃度
	 */
	private Long liveness = 0l;
	
	/**
	 * 是否认证	1-已认证		其他-未认证
	 */
	private int ivalid = 0;
	
	/**
	 * 组织机构代码证
	 */
	private String businessLicenes;
	
	@Transient
	public String[] formatTelphone() {
		if(telphone!=null && !"".equals(telphone)){
			return telphone.split("-");
		}
		
		return null;
	}
	

}
