package edu.ecompus.cas.entity;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 
 * 模块操作动作表
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 上午9:24:33
 */
@Entity
@Table(name = "TAB_ACTION")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)  
public @Data class Action implements Serializable {
	private static final long serialVersionUID = 6409371297329058734L;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
     * 动作中文名称       db_column: name  例如:新增,修改,编辑,删除,查找... etc.
     */ 	
	private String name;
	
	/**
	 * 动作	例如:add,edit,update,search...etc.
	 */
	private String act;
	
	/**
	 * 状态  例如:1-正常    2-注销
	 */
	private int state;

	
	
	
}
