package edu.ecompus.cas.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.UserVerifyDAO;
import edu.ecompus.cas.entity.UserVerify;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;

/**
 * 
 * <b>用户验证 </b>  数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:37:16
 */
@Repository
public class UserVerifyDaoImpl extends ML2TemplateGenericDao<UserVerify> implements
		UserVerifyDAO {

	public UserVerifyDaoImpl() {
		super(UserVerify.class);
	}

	@Override
	public void createUserVerify(UserVerify userVerify) {
		this.createUserVerify(userVerify);
	}

	@Override
	public int updateUserVerifyByUserId(UserVerify userVerify) {
		String sql = "UPDATE UserVerify SET token=?, creaetDate=?, state=? where userId=?";
		return this.executeUpdate(sql.toString(), new Object[]{userVerify.getToken(),userVerify.getCreaetDate(),userVerify.getState(),userVerify.getUserId()});
	}

	@SuppressWarnings("unchecked")
	@Override
	public UserVerify queryUserVerifyByUserId(Long userId) {
		
		StringBuffer sql = new StringBuffer("from UserVerify where id>0");
		sql.append(" and userId='").append(userId).append("'");
		
		List<UserVerify> list = this.hibernateTemplate.find(sql.toString());
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public void deleteUserVerifyByToken(String token) {
		StringBuffer sql = new StringBuffer("delete from UserVerify uv where id>0 uv.token='").append(token).append("'");
		this.executeUpdate(sql.toString(), new Object[]{});
	}
}
