package edu.ecompus.cas.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.RoleDAO;
import edu.ecompus.cas.entity.Role;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;

/**
 * 
 * 角色数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-26 下午3:29:05
 */
@Repository
public class RoleDaoImpl extends ML2TemplateGenericDao<Role> implements RoleDAO {

	public RoleDaoImpl() {
		super(Role.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Role> queryRoleList(Page page) {
		return this.queryForList(
				"select count(id) from Role where state=1",
				"from Role where state=1 ",
				new Object[] {}, page);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Role> queryRoleAll() {
		//byadmin
		StringBuffer sql = new StringBuffer("from Role where byadmin=1 and companyId is null");
		return this.hibernateTemplate.find(sql.toString());
	}
	


}
