package edu.ecompus.cas.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.ModuleDAO;
import edu.ecompus.cas.entity.Module;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;

/**
 * 
 * 模块数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:12:27
 */
@Repository
public class ModuleDaoImpl extends ML2TemplateGenericDao<Module> implements
		ModuleDAO {
	
	public ModuleDaoImpl(){
		super(Module.class);
	}
	

	@SuppressWarnings("unchecked")
	@Override
	public List<Module> getModule(Module parentModule) {
		return this.hibernateTemplate.find("from Module where parentModule=?", new Object[]{parentModule});
	}

}
