package edu.ecompus.cas.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.CompanyAppDAO;
import edu.ecompus.cas.entity.CompanyApp;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
/**
 * <b>单位/学校应用 </b>  数据持久类 操作接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午4:39:31
 */
@Repository
public class CompanyAppDaoImpl extends ML2TemplateGenericDao<CompanyApp> implements
		CompanyAppDAO {

	public CompanyAppDaoImpl() {
		super(CompanyApp.class);
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<CompanyApp> queryCompanyApp(Long school, int apptype,
			int state) {
		StringBuffer sql = new StringBuffer("from CompanyApp where school_id=? ");
		
		if(apptype!=-1){
			sql.append(" and apptype=").append(apptype);
		}
		
		if(state!=-1){
			sql.append(" and state=").append(state);
		}
		
		sql.append(" order by createDate desc");
		
		return this.hibernateTemplate.find(sql.toString(), new Object[]{school});
	}

}
