package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.core.dao.ML2GenericDao;

/**
 * 
 * 用户角色 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:35:51
 */
public interface UserRoleDAO extends ML2GenericDao<UserRole> {
	
	/**
	 * 查询用户角色列表
	 * @param user
	 * @return
	 */
	public List<UserRole> queryUserRoleList(Long userId);
	
	/**
	 * 查询用户角色列表
	 * @param roleNames	 角色名(以逗号隔开)
	 * @param userId	用户编号(必须>0)
	 * @return
	 */
	List<UserRole> queryUserRoleList(String roleNames,Long userId);
	
	/**
	 * 清除用户角色
	 * @param user
	 */
	public void clearUserRole(Long userId);
	
	/**
	 * 根据用户Id查询角色名
	 * @param userId
	 * @return
	 */
	public List<String> queryUserRoleResumeList(Long userId);
	
	/**
	 * 根据角色Id与用户Id 查询用户角色列表
	 * @param roleNames	 角色名(以逗号隔开)
	 * @param userId	用户编号(必须>0)
	 * @return
	 */
	List<UserRole> queryUserRoleList(Long roleId,Long userId);
}
