package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyApp;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserApp;
import edu.ecompus.core.dao.ML2GenericDao;

/**
 * <b>用户应用 </b>  数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午5:05:42
 */
public interface UserAppDAO extends ML2GenericDao<UserApp> {
	
	/**
	 * 查询用户所有APP应用
	 * @param user		*当前用户
	 * @param school	*应用所属学校
	 * @param state		状态(-1不为条件,1-显示,2-隐藏)
	 * @return
	 */
	List<UserApp> queryUserApp(User user,Company school,int state);
	
	/**
	 * 统计用户或者应用使用者数量
	 * @param user		用户实体(null时,统计cpp使用人数)
	 * @param cpp		微博应用(null时,统计用户微博应用数量)
	 * @param school	所属单位学校
	 * @return
	 */
	Long countActivateApp(User user, CompanyApp cpp, Company school);
}
