package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.Role;
import edu.ecompus.cas.entity.RolePermit;
import edu.ecompus.core.dao.ML2GenericDao;


/**
 * 
 * 角色权限 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:14:27
 */
public interface RolePermitDAO extends ML2GenericDao<RolePermit> {
	
	/**
	 * 清除角色权限
	 * @param role
	 */
	public void clearRolePermit(Role role);
	
	/**
	 * 获取角色权限列表
	 * @param role
	 * @return
	 */
	public List<RolePermit> getRolePermitList(Role role);
	
	/**
	 * 根据角色Ids查询角色权限列表
	 * @param roleIds 角色Ids(根据逗号隔开)
	 * @return
	 */
	List<RolePermit> getRolePermitList(String roleIds);
}
