package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.App;
import edu.ecompus.cas.entity.Feedback;
import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
/**
 * <b>意见反馈表</b> 数据持久类 操作接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-1-21 下午1:54:05
 */
public interface FeedbackDAO extends ML2GenericDao<Feedback> {
	/**
	 * 查询所有应用反馈意见
	 * @param status	（-1不为条件， 0：新意见，1:已处理；2:处理完成；3：删除（取消））
	 * @param page		（分页，NULL查询所有）
	 * @return
	 */
	List<Feedback> queryFeedbackList(int status,Page page);
	
	/**
	 * 查询模块反馈意见
	 * @param app	（NULL不为条件）
	 * @param status	（-1不为条件， 0：新意见，1:已处理；2:处理完成；3：删除（取消））
	 * @param page		（分页，NULL查询所有）
	 * @return
	 */
	List<Feedback> queryFeedbackList(Long appid,int status,Page page);
	
	/**
	 * 统计【应用】意见反馈
	 * @param app		应用（NULL为其他）
	 * @param status	状态（-1不为条件， 0：新意见，1:已处理；2:处理完成；3：删除（取消））
	 * @return
	 */
	Long countAppFeedback(Long appid, int status);
}
