package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyTerm;
import edu.ecompus.core.dao.ML2GenericDao;

/**
 * <b>学校学期表</b> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 下午3:02:37
 */
public interface CompanyTermDAO extends ML2GenericDao<CompanyTerm> {
	/**
	 * 	  查询学校学期列表
	 * @param school	学校
	 * @param year		年份（NULL不为条件）
	 * @param term		学期（NULL不为条件，HF上半学期，SH下半学期）
	 * @param state		1-当前学期，其他-历史学期（-1不为条件）
	 * @return
	 */
	List<CompanyTerm> queryCompanyTermList(Company school, String year, String term , int state);
}
