package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.CompanyReg;
import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;

/**
 * <b>机构注册申请表</b> 数据持久类 操作接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-28 上午9:10:05
 */
public interface CompanyRegDAO extends ML2GenericDao<CompanyReg> {
	/**
	 * 根据机构Id查询申请记录
	 * @param schoolId		机构ID
	 * @return
	 */
	List<CompanyReg> queryCompanyRegListByCompanyId(Long companyId);
	
	/**
	 * 综合查询
	 * @param keyword	园所名称、联系人（NULL不为条件）
	 * @param type		机构类型（教育、金融、医疗、会计、法律、美容、婚庆、其它)
	 * @param province
	 * @param city
	 * @param page
	 * @return
	 */
	List<CompanyReg> queryCompanyRegList(String keyword, int type,String province, String city, Page page);
}
