package edu.ecompus.cas.cache.memcached;

import java.util.concurrent.TimeoutException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;

/**
 * Memcached缓存
 * 
 * 
 * @CopyRight CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 *            <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK
 *            version used: <JDK1.6>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-2-4 下午5:32:00
 */
public class MemcachedCache implements Cache {
	Logger logger = LoggerFactory.getLogger(getClass());
	
	private com.google.code.ssm.Cache cache;

	public com.google.code.ssm.Cache getCache() {
		return cache;
	}

	public void setCache(com.google.code.ssm.Cache cache) {
		this.cache = cache;
	}

	@Override
	public String getName() {
		return this.cache.getName();
	}

	@Override
	public Object getNativeCache() {
		return this.cache;
	}

	@Override
	public ValueWrapper get(Object key) {
		Object object = null;
		try {
			logger.info("读取缓存:"+key);
			object = this.cache.get((String) key, SerializationType.JAVA);
		} catch (TimeoutException e) {
			logger.warn("获取 Memcached 缓存超时", e);
		} catch (CacheException e) {
			logger.warn("获取 Memcached 缓存被中断", e);
		}
		return (object != null ? new SimpleValueWrapper(object) : null);
	}

	@Override
	public void put(Object key, Object value) {
		// TODO 若value为null时，跳过保存到缓存，使缓存无效
		if(value==null){
			return;
		}
		
		try {
			logger.info("保存缓存:"+key);
			//expiration=0 不自动 过期	2592000秒=30天后过期
			this.cache.set((String) key, 86400, value, SerializationType.JAVA);
		} catch (TimeoutException e) {
			logger.warn("更新 Memcached 缓存超时", e);
		} catch (CacheException e) {
			logger.warn("更新 Memcached 缓存被中断", e);
		}
	}

	@Override
	public void evict(Object key) {
		try {
			logger.info("删除缓存:"+key);
			this.cache.delete((String) key);
		} catch (TimeoutException e) {
			logger.warn("删除 Memcached 缓存超时", e);
		} catch (CacheException e) {
			logger.warn("删除 Memcached 缓存被中断", e);
		}
	}

	@Override
	public void clear() {
		try {
			logger.info("清空缓存");
			this.cache.flush();
		} catch (TimeoutException e) {
			logger.warn("清除 Memcached 缓存被中断", e);  
		} catch (CacheException e) {
			logger.warn("清除 Memcached 缓存错误", e);
		}
	}

}
