package edu.ecompus.cas;

/**
 * 
 * 常量定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:34:04
 */
public final class Constant {
	//-- Content Type 定义 --//
	public static final String TEXT_TYPE = "text/plain";
	public static final String JSON_TYPE = "application/json";
	public static final String XML_TYPE = "text/xml";
	public static final String HTML_TYPE = "text/html";
	public static final String JS_TYPE = "text/javascript";
	public static final String EXCEL_TYPE = "application/vnd.ms-excel";
	
	//-- 常用数值定义 --//
	public static final long ONE_YEAR_SECONDS = 60 * 60 * 24 * 365;
	
		
	/**
	 * 学生
	 */
	public static final int Student = 1;
	
	
	/**
	 * 超级管理员
	 */
	public static final int Administrator = 3;
	
	/**
	 * 老师
	 */
	public static final int Teacher = 2;
	
	/**
	 * 家长
	 */
	public static final int Parents = 4;
	
	/**
	'1', 'ROLE_USER', '家长', '0', NULL
	'2', 'ROLE_MASTER', '园长', '1', NULL
	'3', 'ROLE_TEACHER', '老师', '1', NULL
	'4', 'ROLE_HEAD', '班主任', '1', NULL
	 **/
	/**
	 * 学生、家长角色
	 */
	public static final Long ROLE_USER = 1l;
	/**
	 * 园长
	 */
	public static final Long ROLE_MASTER = 2l;
	
	/**
	 * 教工、老师角色
	 */
	public static final Long ROLE_TEACHER = 3l;
	
	/**
	 * 班主任角色
	 */
	public static final Long ROLE_HEAD = 4l;
	
	/**
	 * 副园长角色
	 */
	public static final Long ROLE_SECMASTER = 5l;
	
	/**
	 * 空对象
	 */
	public static final String NULL_CODE = "DAO_ERROR_001";
	/**
	 * 空对象字符说明
	 */
	public static final String NULL_MESSAGE = "Object IS NULL";
	
	/**
	 * 查询不支持的数据对象类型
	 */
	public static final String UNSUPPORTEDCLASS_CODE = "DAO_ERROR_002";
	
	/**
	 * 查询不支持的数据对象类型
	 */
	public static final String UNSUPPORTEDCLASS_MESSAGE = "Unsupported class";
	
	
	/**
	 * 用户不存在
	 */
	public static final String USER_USERNAME_ERROR_CODE = "DAO_ERROR_003";
	/**
	 * 用户不存在(根据用户名查询)
	 */
	public static final String USER_USERNAME_ERROR_MESSAGE = "User Is Not Exists";
	
	
	/**
	 * 用户不存在
	 */
	public static final String USER_PASSWORD_ERROR_CODE = "DAO_ERROR_004";
	/**
	 * 用户不存在(根据用户名查询)
	 */
	public static final String USER_PASSWORD_ERROR_MESSAGE = "User's Password Error";
	
}
