/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.util;

import edu.ecompus.cas.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class UrlMatcherUtil {
    private static final Logger logger = LoggerFactory.getLogger(UrlMatcherUtil.class);
    private static AntPathMatcher urlMatcher = new AntPathMatcher();

    public static boolean hasMather(String url, HttpServletRequest req) {
        String requestUrl = req.getServletPath();
        if (requestUrl.indexOf("?") != -1) {
            requestUrl = requestUrl.substring(0, requestUrl.indexOf("?"));
        }
        return UrlMatcherUtil.hasMather(url, requestUrl);
    }

    public static boolean hasMather(String url, String requestUrl) {
        boolean match = false;
        if (url != null && !StringUtil.isEmpty(url)) {
            match = urlMatcher.match(url + "/**", requestUrl);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u6743\u9650[%s]--\u8bf7\u6c42\u6765\u6e90\u5730\u5740[%s]=%s", url + "/**", requestUrl, match));
            }
            if (match) {
                return true;
            }
        }
        return match;
    }

    public static void main(String[] args) {
        System.out.println("1.hasMather=" + UrlMatcherUtil.hasMather("http://www.36uk.com/loginsuccess.php", "http://www.36uk.com/loginsuccess.php"));
        System.out.println("2.hasMather=" + UrlMatcherUtil.hasMather("http://www.36uk.cn/thirdparty/uk/success/**", "http://www.36uk.cn/thirdparty/uk/success/**"));
    }
}

